﻿QIPortalAPI.math = {};

(function() {

let isDecimalLib = typeof(Decimal) != 'undefined';

/*
async function loadDecimalLib()
{
	let promise = new Promise((resolve) =>
	{
		$.getScript('Modules/QIPortal/scripts/decimal.min.js')
		.done(function()
		{
			isDecimalLib = true;
		})
		.fail(function ()
		{
			$.getScript('//cdnjs.cloudflare.com/ajax/libs/decimal.js/10.2.0/decimal.min.js').done(function ()
			{
				isDecimalLib = true;
		 	});
	 	});
	});

	await promise;
}
*/


QIPortalAPI.math.roundType =
{
	mathematical: 0,
	up: 1,
	down: 2,
	halfOrder: 3,
	truncate: 4
}

QIPortalAPI.math.roundEx = function(num, roundType, intervals)
{
	var i, roundTo, loLimit, hiLimit, tmpNum, tmpStr, cmp1, cmp2;
	var number = new Decimal(num);

	var opt = { idx: 0 };
	do
	{
		tmpStr = round_getItem(intervals, opt).toLowerCase();
		if (tmpStr === 'min')
			loLimit = new Decimal(number);
		else
			loLimit = new Decimal(tmpStr);

		tmpStr = round_getItem(intervals, opt).toLowerCase();
		if (tmpStr === 'max')
			hiLimit = new Decimal(number);
		else
			hiLimit = new Decimal(tmpStr);

		roundTo = parseInt(round_getItem(intervals, opt));

		cmp1 = number.cmp(loLimit);
		cmp2 = number.cmp(hiLimit);
	}
	while (!(((cmp1 === 0) || (cmp1 === 1)) && ((cmp2 === 0) || (cmp2 === -1))));

	tmpNum = number;

// PL 03.04.2023 - numerics in DB extended to 8 decimals 
	if (roundTo === -99)
		roundTo = -4;

	//if (roundTo !== -99)
	{
		for (i = 1; i <= Math.abs(roundTo); i++)
		{
			if (roundTo < 0)
				tmpNum = tmpNum.mul(10);
			else
				tmpNum = tmpNum.div(10);
		}

		let cmp = tmpNum.cmp(0);
		let trunc = tmpNum.trunc();
		let sub = tmpNum.sub(trunc);
		let sub2 = trunc.sub(tmpNum);

		switch (roundType)
		{
			case QIPortalAPI.math.roundType.halfOrder:
			{
				let cmp1 = sub.cmp('0.75');
				let cmp2 = sub.cmp('0.25');
				let cmp3 = sub.cmp('-0.75');
				let cmp4 = sub.cmp('-0.25');

				if ((cmp === 0) || (cmp === 1))
				{
					if ((cmp1 === 0) || (cmp1 === 1))
						tmpNum = tmpNum.add(0.6).trunc();
					else
					if (cmp2 === -1)
						tmpNum = trunc;
					else
					{
						tmpNum = trunc.add(0.5);
					}
				}
				else
				{
					if (cmp3 === -1)
						tmpNum = tmpNum.sub(0.6).trunc();
					else
					if ((cmp4 === 0) || (cmp4 === 1))
						tmpNum = trunc;
					else
					{
						tmpNum = trunc.sub(0.5);
					}

				}
				break;
			}

			case QIPortalAPI.math.roundType.mathematical:
			{
				let cmp1 = sub.cmp('0.499999');
				let cmp2 = sub2.cmp('0.499999');

				if ((cmp1 === 0) || (cmp1 === 1))
				{
					if (cmp1 === -1)
						tmpNum = trunc;
					else
						tmpNum = tmpNum.add(0.6).trunc();
				}
				else
				{
					if (cmp2 === -1)
						tmpNum = trunc;
					else
						tmpNum = tmpNum.sub(0.6).trunc();
				}
				break;
			}

			case QIPortalAPI.math.roundType.up:
			{
				let cmp1 = sub.cmp('0.000001');

				if (((cmp === 0) || (cmp === 1)) && (cmp1 === 1))
					tmpNum = tmpNum.add(1).trunc();
				else
					tmpNum = trunc;

				break;
			}

			case QIPortalAPI.math.roundType.down:
			{
				let cmp1 = sub.cmp('0.000001');

				if ((cmp === -1) && (cmp1 === 1))
					tmpNum = tmpNum.sub(1).trunc();
				else
					tmpNum = trunc;

				break;
			}

			case QIPortalAPI.math.roundType.truncate:
			{
				tmpNum = trunc;

				break;
			}
		}

		for (i = 1; i <= Math.abs(roundTo); i++)
		{
			if (roundTo > 0)
				tmpNum = tmpNum.mul(10);
			else
				tmpNum = tmpNum.div(10);
		}
	}

	return tmpNum;
}

function round_getItem(intervals, opt)
{
	let result = '';
	while ((opt.idx < intervals.length) && (intervals[opt.idx] !== ',') && (intervals[opt.idx] !== ';'))
	{
		result += intervals[opt.idx];
		opt.idx++;
	}
	opt.idx++;

	return result.trim();
}

if (! isDecimalLib)
{
	 //loadDecimalLib();
}

})();

// example: QIPortalAPI.math.roundEx('72.555555', QIPortalAPI.math.roundType.mathematical, "min, max, -99")
